    NAME OnlyDrvr

; This is OnlyDrvr.Asm

; This is the link between InteGRiD and the single screen driver included

CGROUP GROUP CODE


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP

;
;  Every screen driver "link" must begin with some executable code that
;  ultimately returns the length of the screen driver and its relative
;  offset within the file (relative to the beginning of the screen driver
;  from InteGRiD's point of view.  By convention I am going to always begin
;  these screen driver "link"s with a short jump instruction followed by the
;  offsets within the file and lengths of each actual driver.  This is to
;  make it easier to have one program that builds these drivers.
;
;  Upon Exit
;    BX = length of screen driver (in 16 byte paragraphs)
;    DX = relative offset of beginning of screen driver

FirstInstruction:
  JMP  SHORT ActualCode

scrDrvrLinkID  DW ?

scrDrvrLength1 DW ?
scrDrvrOffset1 DW ?

ActualCode:
  MOV  BX, CS:scrDrvrLength1
  MOV  DX, CS:scrDrvrOffset1

LongReturn PROC FAR
  RET
LongReturn ENDP


CODE ENDS

    END FirstInstruction
